#include <bits/stdc++.h>
using namespace std;

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

#define fi first
#define se second

typedef long long ll;
typedef long double ld;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int INF = 1e9;

int n;

int dist(int x) {
    return min(x - 1, n - x);
}

int close(int lo, int hi, int x) {
    int lef = lo > 1 ? x - lo + 1 : INF;
    int rig = hi < n ? hi - x + 1 : INF;
    return min(lef, rig);
}

pair<pii, int> cand(int lo, int hi) {
    if (lo == hi) return {{-1, dist(lo)}, lo};

    if (lo == 1) return {{-hi, 0}, 1};
    if (hi == n) return {{-n + lo - 1, 0}, n};

    int mid = (lo + hi) / 2;
    pair<pii, int> lef = {{-close(lo, hi, mid), dist(mid)}, mid};
    pair<pii, int> rig = {{-close(lo, hi, mid + 1), dist(mid + 1)}, mid + 1};
    return min(lef, rig);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int m;
    cin >> n >> m;

    set<pii> intervals;
    set<pair<pii, int>> candidates;

    intervals.insert({1, n});

    while (m--) {
        int x;
        cin >> x;
        auto [lo, hi] = *prev(intervals.lower_bound({x + 1, -1}));

        intervals.erase({lo, hi});
        candidates.erase(cand(lo, hi));

        if (lo != x) {
            intervals.insert({lo, x - 1});
            candidates.insert(cand(lo, x - 1));
        }
        if (hi != x) {
            intervals.insert({x + 1, hi});
            candidates.insert(cand(x + 1, hi));
        }
        
        cout << candidates.begin()->se << '\n';
    }

    return 0;
}

